/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.ar;

import com.ibm.hsc.ccfw.pa.domain.GlobalSurveillanceAnalysisDomain;
import com.ibm.hsc.ccfw.pa.domain.LocalSurveillanceAnalysisDomain;
import com.ibm.hsc.ccfw.pa.event.SurveillanceNotificationDataEvent;
import com.ibm.hsc.ccfw.pa.system.PICecFsp;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.settings.network.config.NetworkInterfaceConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.Incident;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.MessageService;
import com.ibm.hwmca.fw.util.msgsvc.PartitionedMessage;
import com.ibm.hwmca.p.pa.event.GlobalSurveillanceDataEvent;
import com.ibm.hwmca.p.pa.event.LocalSurveillanceDomainAnalysisEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.pa.problem.SupportingSurveillanceInfo;
import com.ibm.hwmca.xfw.pa.ar.AnalysisDomainAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemotePartitionSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class LocalSurveillanceDomainAnalysisRoutine
extends AnalysisDomainAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPALSART";
    private static final String TRACE_MASKF = "PPALSARF";
    private static final String TRACE_MASKD = "PPALSARD";
    private static final String SURVEILLANCE_ISOLATE_FRU = "FSPSP33";
    private LocalSurveillanceAnalysisDomain lsad = null;
    private Set allAcceptableStatusPILParImages = new HashSet();
    private Set allUnacceptableStatusPILParImages = new HashSet();
    private ArrayList mailBoxProblems = new ArrayList();
    private ArrayList phypFSPFailures = new ArrayList();
    private ArrayList fspPHYPFailures = new ArrayList();
    private ArrayList hmcFSPFailures = new ArrayList();
    private ArrayList hmcPartitionFailures = new ArrayList();
    private ArrayList redundantHmcPartitionFailures = new ArrayList();
    private ArrayList hmcHmcFailures = new ArrayList();
    private ArrayList redundantHmcHmcFailures = new ArrayList();
    private ArrayList otherFailures = new ArrayList();
    private CommonServiceIncident workIncident = null;
    private HashMap failingSystems = new HashMap();
    public static int FSP_RESET_RELOAD_NON_TIMEOUT = 4432;
    public static int FSP_RESET_RELOAD = 4448;
    public static int FSP_MAIL_BOX_TIMEOUT = 4434;
    public static int FSP_MAIL_BOX_TIMEOUT_NO_RELOAD = 4433;

    public LocalSurveillanceDomainAnalysisRoutine() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(ProblemAnalysisEvent problemAnalysisEvent) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Trace.trace((String)TRACE_MASKT, (Object)"-->LocalSurveillanceDomainAnalysisRoutine.analyze()");
        this.fspPHYPFailures.clear();
        this.hmcFSPFailures.clear();
        this.hmcHmcFailures.clear();
        this.hmcPartitionFailures.clear();
        this.mailBoxProblems.clear();
        this.otherFailures.clear();
        this.phypFSPFailures.clear();
        this.redundantHmcHmcFailures.clear();
        this.redundantHmcPartitionFailures.clear();
        LocalSurveillanceDomainAnalysisEvent localSurveillanceDomainAnalysisEvent = (LocalSurveillanceDomainAnalysisEvent)problemAnalysisEvent;
        DomainIdentifier domainIdentifier = CommonDataEvent.extractDomainId((String)localSurveillanceDomainAnalysisEvent.getIncidentPoolId());
        this.setLsad((LocalSurveillanceAnalysisDomain)DomainManager.getDomainManager().get(domainIdentifier));
        if (this.getLsad() == null) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-- analyze(): domain (" + domainIdentifier.getDID() + ") not found"));
            return;
        }
        Set set = this.getLsad().getParticipants();
        synchronized (set) {
            object5 = this.getLsad().getParticipants().iterator();
            while (object5.hasNext()) {
                Trace.trace((String)TRACE_MASKD, (Object)("PEER CONSOLE SYSTEM" + ((PASystem)object5.next()).getSystemName()));
            }
        }
        set = null;
        set = LocalSurveillanceDomainAnalysisRoutine.getAnalyzingIncidentPool((String)localSurveillanceDomainAnalysisEvent.getIncidentPoolId());
        Trace.trace((String)TRACE_MASKT, (Object)("TEST WITH Analyzin POOL it's size = " + set.size()));
        if (set != null) {
            this.moveIncidentsByType((IncidentPool)set);
        }
        Trace.trace((String)TRACE_MASKT, (Object)("After iteration and removal of all? size = " + set.size()));
        Trace.trace((String)TRACE_MASKD, (Object)("fspPHYPFailures.size(" + this.fspPHYPFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("phypFSPFailures.size(" + this.phypFSPFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcFSPFailures.size(" + this.hmcFSPFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcPartitionFailures.size(" + this.hmcPartitionFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("redundantHmcPartitionFailures.size(" + this.redundantHmcPartitionFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("redundantHmcHmcFailures.size(" + this.redundantHmcHmcFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcHmcFailures.size(" + this.hmcHmcFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("otherFailures.size(" + this.otherFailures.size() + ")"));
        object5 = new HashMap();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.mergeFspPhypFailures();
        this.mergePhypHmcFspFailures();
        if (this.getRedundantHmcHmcFailures().size() > 0 && this.getHmcHmcFailures().size() > 0) {
            this.redundantCheck(this.getRedundantHmcHmcFailures(), this.getHmcHmcFailures());
        }
        this.getHmcHmcFailures().addAll(this.getRedundantHmcHmcFailures());
        if (this.getRedundantHmcPartitionFailures().size() > 0 && this.getHmcPartitionFailures().size() > 0) {
            this.redundantCheck(this.getRedundantHmcPartitionFailures(), this.getHmcPartitionFailures());
        }
        this.getHmcPartitionFailures().addAll(this.getRedundantHmcPartitionFailures());
        Trace.trace((String)TRACE_MASKD, (Object)("fspPHYPFailures.size(" + this.fspPHYPFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("phypFSPFailures.size(" + this.phypFSPFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcFSPFailures.size(" + this.hmcFSPFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcPartitionFailures.size(" + this.hmcPartitionFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("redundantHmcHmcFailures.size(" + this.redundantHmcHmcFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcHmcFailures.size(" + this.hmcHmcFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("hmcPartitionFailures.size(" + this.hmcPartitionFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("redundantHmcPartitionFailures.size(" + this.redundantHmcPartitionFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)("otherFailures.size(" + this.otherFailures.size() + ")"));
        Trace.trace((String)TRACE_MASKD, (Object)"report problems");
        this.addProblems(this.mailBoxProblems, (IncidentPool)set);
        this.addProblems(this.fspPHYPFailures, (IncidentPool)set);
        this.addProblems(this.phypFSPFailures, (IncidentPool)set);
        HashMap hashMap4 = new HashMap();
        this.getNetstat(hashMap4);
        ArrayList arrayList = new ArrayList();
        NetworkSettingsConfig networkSettingsConfig = NetworkSettingsConfig.getNetworkSettingsConfig();
        arrayList.addAll(networkSettingsConfig.getNetworkInterfaces());
        Trace.trace((String)TRACE_MASKT, (Object)("cardStat.size() = " + hashMap4.size() + " networkInterfaces.size() = " + arrayList.size()));
        ArrayList<Object> arrayList2 = hashMap4.keySet().iterator();
        while (arrayList2.hasNext()) {
            object4 = (String)arrayList2.next();
            Trace.trace((String)TRACE_MASKT, (Object)("cardStat key= " + (String)object4 + " value = " + hashMap4.get(object4)));
        }
        object4 = arrayList.iterator();
        while (object4.hasNext()) {
            Trace.trace((String)TRACE_MASKT, (Object)("NetworkInterface " + ((NetworkInterfaceConfig)object4.next()).toString()));
        }
        if (this.getRunningInterfaces(hashMap4).size() == 0) {
            Trace.trace((String)TRACE_MASKD, (Object)"no networking at all ");
            this.noNetProblem();
            set.add((Incident)this.workIncident);
            Trace.trace((String)TRACE_MASKT, (Object)"<-- No NetworkLocalSurveillanceDomainAnalysisRoutine.analyze()");
            return;
        }
        if (this.privateNetFailure(arrayList, hashMap4)) {
            Trace.trace((String)TRACE_MASKD, (Object)"no public networking");
            this.noNetProblem();
            set.add((Incident)this.workIncident);
            Trace.trace((String)TRACE_MASKT, (Object)"<-- No public NetworkLocalSurveillanceDomainAnalysisRoutine.analyze()");
            return;
        }
        Trace.trace((String)TRACE_MASKD, (Object)"Still here test looking through peers and remote machines");
        arrayList2 = this.getLsad().getActiveRemoteMachines();
        Trace.trace((String)TRACE_MASKD, (Object)("activeRemotes.size()=" + arrayList2.size()));
        Trace.trace((String)TRACE_MASKD, (Object)("activeConsoles.size()=" + this.getLsad().getParticipants().size()));
        object4 = arrayList2.iterator();
        while (object4.hasNext()) {
            Trace.trace((String)TRACE_MASKD, (Object)(" getMOSName from remoteMachine" + ((RemoteMachineSystem)object4.next()).getMOSystemName()));
        }
        arrayList2 = new ArrayList<Object>();
        object4 = (GlobalSurveillanceAnalysisDomain)DomainManager.getDomainManager().get(GlobalSurveillanceAnalysisDomain.GSAD_DOMAINID);
        PIFru pIFru = new PIFru();
        pIFru.setFruClass(12);
        int n = 0;
        if (this.hmcPartitionFailures.size() > 0) {
            ++n;
        }
        if (this.hmcFSPFailures.size() > 0) {
            ++n;
        }
        if (this.otherFailures.size() > 0) {
            ++n;
        }
        if (this.hmcHmcFailures.size() > 0) {
            ++n;
        }
        if (n > 1) {
            Trace.trace((String)TRACE_MASKD, (Object)"multipleFailures  = ");
            object3 = new ArrayList();
            ((ArrayList)object3).addAll(this.hmcPartitionFailures);
            ((ArrayList)object3).addAll(this.hmcFSPFailures);
            ((ArrayList)object3).addAll(this.otherFailures);
            ((ArrayList)object3).addAll(this.hmcHmcFailures);
            Trace.trace((String)TRACE_MASKD, (Object)("allFailures.size()  = " + ((ArrayList)object3).size()));
            object2 = ((ArrayList)object3).iterator();
            if (object2.hasNext()) {
                object = (CommonServiceIncident)object2.next();
                PIProblem pIProblem = (PIProblem)object.getProblem();
                pIProblem.setServiceableEventText(new BaseMessageText("XPA7690").toString());
                pIFru.setPartNumber("HMCMULTNTWK");
                pIFru.addLocation(pIProblem.getReportingRemoteMachineSystem().getMTMS() + "-SPOT-LAN-CONNECTION");
                arrayList2.add(object);
                object2 = ((ArrayList)object3).iterator();
                this.addSupportingInfo((Iterator)object2, pIProblem);
                pIProblem.addPart((CommonPaFru)pIFru);
            }
        } else if (this.hmcPartitionFailures.size() > 0) {
            Trace.trace((String)TRACE_MASKD, (Object)("hmcPartitionFailures.size() = " + this.hmcPartitionFailures.size()));
            object3 = (CommonServiceIncident)this.hmcPartitionFailures.get(0);
            object2 = (PIProblem)object3.getProblem();
            pIFru.setPartNumber("PTNNTWK");
            pIFru.addLocation(object2.getReportingRemoteMachineSystem().getMTMS() + "-SPOT-LAN-CONNECTION");
            object2.addPart((CommonPaFru)pIFru);
            if (this.hmcPartitionFailures.size() > 1) {
                if (this.failingSystems.size() == 1) {
                    object2.setRefcode("B3030004");
                } else if (this.failingSystems.size() > 1) {
                    object2.setRefcode("B3030003");
                    object2.setServiceableEventText(new BaseMessageText("XPA7684").toString());
                }
            }
            object = this.hmcPartitionFailures.iterator();
            this.addSupportingInfo((Iterator)object, (PIProblem)object2);
            arrayList2.add(object3);
        } else if (this.hmcFSPFailures.size() > 0) {
            Trace.trace((String)TRACE_MASKD, (Object)("hmcFSPFailures.size() = " + this.hmcFSPFailures.size()));
            object3 = (CommonServiceIncident)this.hmcFSPFailures.get(0);
            object2 = (PIProblem)object3.getProblem();
            pIFru.setPartNumber("SPNETWK");
            pIFru.addLocation(object2.getReportingRemoteMachineSystem() + "-SP-LAN");
            object2.addPart((CommonPaFru)pIFru);
            if (this.hmcFSPFailures.size() > 1) {
                object2.setServiceableEventText(new BaseMessageText("XPA7685").toString());
                object2.setRefcode("B3030007");
                object = this.hmcFSPFailures.iterator();
                this.addSupportingInfo((Iterator)object, (PIProblem)object2);
            }
            arrayList2.add(object3);
        } else if (this.otherFailures.size() > 0) {
            Trace.trace((String)TRACE_MASKD, (Object)("otherFailures.size() = " + this.otherFailures.size()));
            object3 = this.otherFailures.iterator();
            while (object3.hasNext()) {
                arrayList2.add((CommonServiceIncident)object3.next());
            }
        } else if (this.hmcHmcFailures.size() > 0) {
            Trace.trace((String)TRACE_MASKD, (Object)("hmchmcFailures.size() = " + this.hmcHmcFailures.size()));
            object3 = (CommonServiceIncident)this.hmcHmcFailures.get(0);
            object2 = (PIProblem)object3.getProblem();
            if (this.failingSystems.size() > 1) {
                object2.setRefcode("B3030009");
                object2.setServiceableEventText(new BaseMessageText("XPA7686").toString());
            } else {
                object2.setRefcode("B3030008");
                object2.setServiceableEventText(new BaseMessageText("XPA7687").toString());
            }
            pIFru.setPartNumber("HMCNTWK");
            pIFru.addLocation(object2.getReportingRemoteMachineSystem() + "-SPOT-LAN-CONNECTION");
            object2.addPart((CommonPaFru)pIFru);
            arrayList2.add(object3);
            if (this.hmcHmcFailures.size() > 1) {
                object = this.hmcHmcFailures.iterator();
                this.addSupportingInfo((Iterator)object, (PIProblem)object2);
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)("remainingIncidents.size() = " + arrayList2.size()));
        Trace.trace((String)TRACE_MASKD, (Object)("failingSystems.size() = " + this.failingSystems.size()));
        object3 = ((GlobalSurveillanceAnalysisDomain)((Object)object4)).getPrimary();
        object2 = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        object = object2.getConsoleSystem();
        if (object.equals(object3)) {
            object3 = null;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            CommonServiceIncident commonServiceIncident = (CommonServiceIncident)arrayList2.get(i);
            commonServiceIncident.getProblem().setDomainId(GlobalSurveillanceAnalysisDomain.GSAD_DOMAINID);
            PIFru pIFru2 = new PIFru();
            pIFru2.setFruClass(4);
            pIFru2.setPartNumber(SURVEILLANCE_ISOLATE_FRU);
            pIFru2.setReplacementGroup("M");
            commonServiceIncident.getProblem().getParts().add(0, pIFru2);
            if (object3 == null) {
                Trace.trace((String)TRACE_MASKD, (Object)"this is primary create a GSADE and post it ");
                GlobalSurveillanceDataEvent globalSurveillanceDataEvent = new GlobalSurveillanceDataEvent((Object)this);
                globalSurveillanceDataEvent.setSystem(commonServiceIncident.getProblem().getPrimaryAnalyzingConsoleSystem());
                globalSurveillanceDataEvent.setData((Object)commonServiceIncident.getProblem());
                this.eventManager.handleEvent((ProblemAnalysisEvent)globalSurveillanceDataEvent);
                continue;
            }
            Trace.trace((String)TRACE_MASKD, (Object)("not primary distribute directly to the globalPrimary(" + object3.getSystemName() + ")"));
            this.distributeToGlobalPrimary(commonServiceIncident, (GlobalSurveillanceAnalysisDomain)((Object)object4), (PASystem)object3);
        }
        Iterator iterator = null;
        iterator = set.iterator();
        Trace.trace((String)TRACE_MASKD, (Object)"Final loop on pool to show what will be opened locally");
        while (iterator.hasNext()) {
            Trace.trace((String)TRACE_MASKD, (Object)((CommonServiceIncident)iterator.next()).getProblem().getRefcode());
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-- LocalSurveillanceDomainAnalysisRoutine.analyze()");
    }

    private void removeItems(HashMap hashMap, ArrayList arrayList) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CommonServiceIncident commonServiceIncident = (CommonServiceIncident)hashMap.get(iterator.next());
            int n = this.getIndexOf(commonServiceIncident, arrayList);
            if (n == -1) continue;
            arrayList.remove(n);
        }
    }

    private int getIndexOf(CommonServiceIncident commonServiceIncident, ArrayList arrayList) {
        int n = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!commonServiceIncident.equals((CommonServiceIncident)arrayList.get(i))) continue;
            return i;
        }
        return n;
    }

    private void reportProblems(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                ((CommonProblem)arrayList.get(i)).open();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void addProblems(ArrayList arrayList, IncidentPool incidentPool) {
        Iterator iterator = incidentPool.iterator();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                CommonServiceIncident commonServiceIncident = (CommonServiceIncident)arrayList.get(i);
                commonServiceIncident.getProblem().setReplicatable(false);
                incidentPool.add((Incident)commonServiceIncident);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void getNetstat(HashMap hashMap) {
        ArrayList arrayList = new ArrayList();
        NetworkSettingsConfig networkSettingsConfig = NetworkSettingsConfig.getNetworkSettingsConfig();
        Process process = null;
        try {
            process = RootProcess.startProgram((String)"queryNetDevices");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            string = bufferedReader.readLine();
            while (string != null) {
                boolean bl;
                Trace.trace((String)TRACE_MASKD, (Object)string);
                String[] stringArray = string.split("\\s+");
                if (stringArray.length != 12) {
                    Trace.trace((String)TRACE_MASKF, (Object)("getNetstat: wrong number of tokens in output: " + stringArray.length));
                    string = bufferedReader.readLine();
                    continue;
                }
                String string2 = stringArray[0];
                String string3 = stringArray[11];
                boolean bl2 = bl = string3.indexOf("R") != -1;
                if (bl) {
                    Trace.trace((String)TRACE_MASKF, (Object)("Interface status for " + string2 + " is running"));
                    hashMap.put(string2, "R");
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)("Interface status for " + string2 + " is not running"));
                    hashMap.put(string2, "N");
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void distributeToGlobalPrimary(CommonServiceIncident commonServiceIncident, GlobalSurveillanceAnalysisDomain globalSurveillanceAnalysisDomain, PASystem pASystem) {
        Trace.trace((String)TRACE_MASKF, (Object)"--> distributeProblem");
        StringBuffer stringBuffer = new StringBuffer();
        CommonProblem commonProblem = commonServiceIncident.getProblem();
        commonProblem.setProblemNumber(0);
        XMLHelper.outToXML((Object)commonProblem, (StringBuffer)stringBuffer, commonProblem.getClass());
        Trace.trace((String)TRACE_MASKF, (Object)("number:" + commonProblem.getProblemNumber()));
        Trace.trace((String)TRACE_MASKF, (Object)("reporting RemoteMachineSystem:" + commonProblem.getReportingRemoteMachineSystem()));
        Trace.trace((String)TRACE_MASKF, (Object)("primary analyzing ConsoleSystem:" + commonProblem.getPrimaryAnalyzingConsoleSystem()));
        Trace.trace((String)TRACE_MASKF, (Object)("failing system:" + commonProblem.getFailingSystem()));
        Trace.trace((String)TRACE_MASKF, (Object)("problem XMLed:" + stringBuffer.toString()));
        try {
            PartitionedMessage partitionedMessage = new PartitionedMessage(globalSurveillanceAnalysisDomain.getDomainMessageId(), (Serializable)((Object)"DP_DIAG"), (Serializable)((Object)stringBuffer.toString()));
            HashSet<PASystem> hashSet = new HashSet<PASystem>();
            hashSet.add(pASystem);
            MessageService.getMessageService().publishToRemote((Message)partitionedMessage, hashSet, false);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"could not distribute problem open.");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        Trace.trace((String)TRACE_MASKF, (Object)"<-- distributeProblem");
    }

    public ArrayList getFspPHYPFailures() {
        return this.fspPHYPFailures;
    }

    public ArrayList getHmcFSPFailures() {
        return this.hmcFSPFailures;
    }

    public ArrayList getHmcPartitionFailures() {
        return this.hmcPartitionFailures;
    }

    public ArrayList getMailBoxProblems() {
        return this.mailBoxProblems;
    }

    public ArrayList getOtherFailures() {
        return this.otherFailures;
    }

    public ArrayList getPhypFSPFailures() {
        return this.phypFSPFailures;
    }

    public void setFspPHYPFailures(ArrayList arrayList) {
        this.fspPHYPFailures = arrayList;
    }

    public void setHmcFSPFailures(ArrayList arrayList) {
        this.hmcFSPFailures = arrayList;
    }

    public void setHmcPartitionFailures(ArrayList arrayList) {
        this.hmcPartitionFailures = arrayList;
    }

    public void setMailBoxProblems(ArrayList arrayList) {
        this.mailBoxProblems = arrayList;
    }

    public void setOtherFailures(ArrayList arrayList) {
        this.otherFailures = arrayList;
    }

    public void setPhypFSPFailures(ArrayList arrayList) {
        this.phypFSPFailures = arrayList;
    }

    protected void moveIncidentsByType(IncidentPool incidentPool) {
        Iterator iterator = null;
        if (incidentPool != null) {
            iterator = incidentPool.iterator();
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        while (iterator != null && iterator.hasNext()) {
            CommonServiceIncident commonServiceIncident;
            this.workIncident = commonServiceIncident = (CommonServiceIncident)iterator.next();
            if (commonServiceIncident.getProblem() == null || commonServiceIncident.getProblem().getPrimaryDataEvent() == null) continue;
            Trace.trace((String)TRACE_MASKD, (Object)("MoveInicidentsByType problem.getRefcode()= " + commonServiceIncident.getProblem().getRefcode()));
            DistributedDataEvent distributedDataEvent = (DistributedDataEvent)commonServiceIncident.getProblem().getPrimaryDataEvent();
            if (distributedDataEvent instanceof SurveillanceNotificationDataEvent) {
                Trace.trace((String)TRACE_MASKD, (Object)("SurveillanceNotificationDataEvent reason code to compare on = " + ((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason()));
                if (commonServiceIncident.getProblem().getReportingRemoteMachineSystem() != null && commonServiceIncident.getProblem().getReportingRemoteMachineSystem().getIPAddrList() != null) {
                    Trace.trace((String)TRACE_MASKD, (Object)(" reportingSystem ipAddressLength " + commonServiceIncident.getProblem().getReportingRemoteMachineSystem().getIPAddrList().size()));
                }
                if (commonServiceIncident.getProblem().getFailingSystem() != null && commonServiceIncident.getProblem().getFailingSystem().getIPAddrList() != null) {
                    Trace.trace((String)TRACE_MASKD, (Object)(" reportingSystem ipAddressLength " + commonServiceIncident.getProblem().getFailingSystem().getIPAddrList().size()));
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 2 && !this.isIn(this.getFspPHYPFailures(), commonServiceIncident)) {
                    this.getFspPHYPFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 3 && !this.isIn(this.getPhypFSPFailures(), commonServiceIncident)) {
                    this.getPhypFSPFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 1 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                    this.getHmcFSPFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 4 && !this.isIn(this.getHmcPartitionFailures(), commonServiceIncident)) {
                    this.getHmcPartitionFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 5 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                    this.getHmcFSPFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 6 && !this.isIn(this.getHmcHmcFailures(), commonServiceIncident)) {
                    this.getHmcHmcFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 7 && !this.isIn(this.getRedundantHmcHmcFailures(), commonServiceIncident)) {
                    this.getRedundantHmcHmcFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 8 && !this.isIn(this.getRedundantHmcPartitionFailures(), commonServiceIncident)) {
                    this.getRedundantHmcPartitionFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 4097 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                    this.getHmcFSPFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 4098 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                    this.getHmcFSPFailures().add(commonServiceIncident);
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason() == 4096 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                    this.getHmcFSPFailures().add(commonServiceIncident);
                }
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)"MoveInicidentsByType nonSurveillanceNotificationDataEvent");
                String string = commonServiceIncident.getProblem().getRefcode();
                Trace.trace((String)TRACE_MASKD, (Object)("refcode to compare on " + string));
                if (string != null && string.length() > 0) {
                    String string2 = string.substring(4);
                    Trace.trace((String)TRACE_MASKD, (Object)("reasonStr " + string2));
                    int n = Integer.valueOf(string2, 16);
                    Trace.trace((String)TRACE_MASKD, (Object)("reason code to compare on = " + n));
                    if (n == 58419 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                        this.getHmcFSPFailures().add(commonServiceIncident);
                    } else if (n == 58420 && !this.isIn(this.getFspPHYPFailures(), commonServiceIncident)) {
                        this.getFspPHYPFailures().add(commonServiceIncident);
                    } else if (n == 58450 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                        this.getHmcFSPFailures().add(commonServiceIncident);
                    } else if (n == 58450 && !this.isIn(this.getHmcFSPFailures(), commonServiceIncident)) {
                        this.getHmcFSPFailures().add(commonServiceIncident);
                    } else if (n == FSP_MAIL_BOX_TIMEOUT_NO_RELOAD && !this.isIn(this.getPhypFSPFailures(), commonServiceIncident)) {
                        this.getPhypFSPFailures().add(commonServiceIncident);
                    } else if (n == FSP_MAIL_BOX_TIMEOUT && !this.isIn(this.getPhypFSPFailures(), commonServiceIncident)) {
                        this.getPhypFSPFailures().add(commonServiceIncident);
                    } else if (n == FSP_RESET_RELOAD && !this.isIn(this.getPhypFSPFailures(), commonServiceIncident)) {
                        this.getPhypFSPFailures().add(commonServiceIncident);
                    } else if (n == FSP_RESET_RELOAD_NON_TIMEOUT && !this.isIn(this.getPhypFSPFailures(), commonServiceIncident)) {
                        this.getPhypFSPFailures().add(commonServiceIncident);
                    } else {
                        this.getOtherFailures().add(commonServiceIncident);
                    }
                }
            }
            if (!this.failingSystems.containsKey(commonServiceIncident.getProblem().getFailingSystem().getMTMS())) {
                this.failingSystems.put(commonServiceIncident.getProblem().getFailingSystem().getMTMS(), commonServiceIncident);
            }
            incidentPool.remove((Incident)commonServiceIncident);
        }
    }

    public ArrayList getHmcHmcFailures() {
        return this.hmcHmcFailures;
    }

    public void setHmcHmcFailures(ArrayList arrayList) {
        this.hmcHmcFailures = arrayList;
    }

    protected void mergeFspPhypFailures() {
        Iterator iterator = this.getFspPHYPFailures().iterator();
        while (iterator.hasNext()) {
            SupportingSurveillanceInfo supportingSurveillanceInfo;
            CommonServiceIncident commonServiceIncident;
            Object object;
            boolean bl = false;
            CommonServiceIncident commonServiceIncident2 = (CommonServiceIncident)iterator.next();
            Iterator iterator2 = this.getPhypFSPFailures().iterator();
            while (iterator2.hasNext()) {
                object = (CommonServiceIncident)iterator2.next();
                Trace.trace((String)TRACE_MASKD, (Object)("fspIncide reportingMachine = " + commonServiceIncident2.getProblem().getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("fspIncide failingMachine = " + commonServiceIncident2.getProblem().getFailingSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("phypIncident reportingMachine = " + object.getProblem().getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("phypIncident reportingMachine = " + object.getProblem().getFailingSystem()));
                if (!commonServiceIncident2.getProblem().getReportingRemoteMachineSystem().equals((Object)object.getProblem().getReportingRemoteMachineSystem()) || !commonServiceIncident2.getProblem().getFailingSystem().equals((Object)object.getProblem().getFailingSystem())) continue;
                commonServiceIncident2.getProblem().addSecondaryDataEvent(object.getProblem().getPrimaryDataEvent());
                iterator2.remove();
                commonServiceIncident2.getProblem().setRefcode("B3030013");
                commonServiceIncident2.getProblem().setServiceableEventText(new BaseMessageText("XPA7689").toString());
                commonServiceIncident = new PIFru();
                commonServiceIncident.setFruClass(12);
                commonServiceIncident.setPartNumber("MAILBOX");
                commonServiceIncident.addLocation(commonServiceIncident2.getProblem().getFailingSystem().getMTMS() + "-NO-NET");
                commonServiceIncident2.getProblem().addPart((CommonPaFru)commonServiceIncident);
                this.mailBoxProblems.add(commonServiceIncident2);
                bl = true;
                supportingSurveillanceInfo = new SupportingSurveillanceInfo();
                this.setSupportingInfo(supportingSurveillanceInfo, (PIProblem)object.getProblem());
                ((PIProblem)commonServiceIncident2.getProblem()).setSupportingSurvInfo(supportingSurveillanceInfo);
                Trace.trace((String)TRACE_MASKD, (Object)"mergein fspPhyp with phypFsp");
            }
            if (bl) {
                iterator.remove();
                continue;
            }
            object = this.getHmcPartitionFailures().iterator();
            while (object.hasNext()) {
                commonServiceIncident = (CommonServiceIncident)object.next();
                Trace.trace((String)TRACE_MASKD, (Object)("fspIncide reportingMachine = " + commonServiceIncident2.getProblem().getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("fspIncide failingMachine = " + commonServiceIncident2.getProblem().getFailingSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("hmcPartIncident reportingMachine = " + commonServiceIncident.getProblem().getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("hmcPartIncident reportingMachine = " + commonServiceIncident.getProblem().getFailingSystem()));
                if (!commonServiceIncident2.getProblem().getReportingRemoteMachineSystem().equals((Object)commonServiceIncident.getProblem().getReportingRemoteMachineSystem()) || !commonServiceIncident2.getProblem().getFailingSystem().equals((Object)commonServiceIncident.getProblem().getFailingSystem())) continue;
                commonServiceIncident2.getProblem().addSecondaryDataEvent(commonServiceIncident.getProblem().getPrimaryDataEvent());
                supportingSurveillanceInfo = new SupportingSurveillanceInfo();
                this.setSupportingInfo(supportingSurveillanceInfo, (PIProblem)commonServiceIncident.getProblem());
                ((PIProblem)commonServiceIncident2.getProblem()).setSupportingSurvInfo(supportingSurveillanceInfo);
                object.remove();
                Trace.trace((String)TRACE_MASKD, (Object)"merging a hmcPartionsfailure with  fspPhyp non mailbox");
            }
        }
    }

    protected void mergePhypHmcFspFailures() {
        Iterator iterator = this.phypFSPFailures.iterator();
        while (iterator.hasNext()) {
            CommonServiceIncident commonServiceIncident = (CommonServiceIncident)iterator.next();
            Iterator iterator2 = this.hmcFSPFailures.iterator();
            while (iterator2.hasNext()) {
                CommonServiceIncident commonServiceIncident2 = (CommonServiceIncident)iterator2.next();
                Trace.trace((String)TRACE_MASKD, (Object)("fspIncide reportingMachine = " + commonServiceIncident.getProblem().getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("fspIncide failingMachine = " + commonServiceIncident.getProblem().getFailingSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("hmcFSP reportingMachine = " + commonServiceIncident2.getProblem().getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("hmcFSP reportingMachine = " + commonServiceIncident2.getProblem().getFailingSystem()));
                if (!commonServiceIncident.getProblem().getReportingRemoteMachineSystem().equals((Object)commonServiceIncident2.getProblem().getReportingRemoteMachineSystem()) && !commonServiceIncident.getProblem().getReportingRemoteMachineSystem().equals((Object)commonServiceIncident2.getProblem().getFailingSystem()) && !commonServiceIncident.getProblem().getFailingSystem().equals((Object)commonServiceIncident2.getProblem().getReportingRemoteMachineSystem()) && !commonServiceIncident.getProblem().getFailingSystem().equals((Object)commonServiceIncident2.getProblem().getFailingSystem())) continue;
                commonServiceIncident.getProblem().addSecondaryDataEvent(commonServiceIncident2.getProblem().getPrimaryDataEvent());
                SupportingSurveillanceInfo supportingSurveillanceInfo = new SupportingSurveillanceInfo();
                this.setSupportingInfo(supportingSurveillanceInfo, (PIProblem)commonServiceIncident2.getProblem());
                ((PIProblem)commonServiceIncident.getProblem()).setSupportingSurvInfo(supportingSurveillanceInfo);
                iterator2.remove();
                Trace.trace((String)TRACE_MASKD, (Object)"merging a hmcFSPfailure with  phypFsp non mailbox");
                PIFru pIFru = new PIFru();
                pIFru.setFruClass(12);
                pIFru.setPartNumber("SPNETWK");
                pIFru.addLocation(commonServiceIncident.getProblem().getFailingSystem().getMTMS() + "-SP-LAN");
                commonServiceIncident.getProblem().addPart((CommonPaFru)pIFru);
            }
        }
    }

    protected void setSupportingInfo(SupportingSurveillanceInfo supportingSurveillanceInfo, PIProblem pIProblem) {
        if (pIProblem == null) {
            return;
        }
        if (pIProblem.getReportingRemoteMachineSystem() != null) {
            supportingSurveillanceInfo.setEndPointA(pIProblem.getReportingRemoteMachineSystem());
        }
        if (pIProblem.getFailingSystem() != null) {
            supportingSurveillanceInfo.setEndPointB(pIProblem.getFailingSystem());
        }
        if (pIProblem.getRefcode() != null) {
            supportingSurveillanceInfo.setRefcode(pIProblem.getRefcode());
        }
    }

    protected void removeDups(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PIProblem pIProblem = (PIProblem)((CommonServiceIncident)iterator.next()).getProblem();
            Iterator iterator2 = arrayList.iterator();
            iterator2.next();
            while (iterator2.hasNext()) {
                PIProblem pIProblem2 = (PIProblem)((CommonServiceIncident)iterator2.next()).getProblem();
                if (!pIProblem.getFailingSystem().equals((Object)pIProblem2.getFailingSystem()) || !pIProblem.getRefcode().equals(pIProblem2.getRefcode())) continue;
                iterator2.remove();
            }
        }
    }

    public ArrayList getRedundantHmcHmcFailures() {
        return this.redundantHmcHmcFailures;
    }

    public ArrayList getRedundantHmcPartitionFailures() {
        return this.redundantHmcPartitionFailures;
    }

    public void setRedundantHmcHmcFailures(ArrayList arrayList) {
        this.redundantHmcHmcFailures = arrayList;
    }

    public void setRedundantHmcPartitionFailures(ArrayList arrayList) {
        this.redundantHmcPartitionFailures = arrayList;
    }

    protected void redundantCheck(ArrayList arrayList, ArrayList arrayList2) {
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            CommonProblem commonProblem = ((CommonServiceIncident)iterator.next()).getProblem();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                CommonProblem commonProblem2 = ((CommonServiceIncident)iterator2.next()).getProblem();
                Trace.trace((String)TRACE_MASKD, (Object)("rfProblem reportingMachine = " + commonProblem2.getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("rfProblem failingMachine = " + commonProblem2.getFailingSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("nrfProblem reportingMachine = " + commonProblem.getReportingRemoteMachineSystem()));
                Trace.trace((String)TRACE_MASKD, (Object)("nrfProblem reportingMachine = " + commonProblem.getFailingSystem()));
                if (!commonProblem2.getReportingRemoteMachineSystem().equals((Object)commonProblem.getReportingRemoteMachineSystem()) || !commonProblem2.getFailingSystem().equals((Object)commonProblem.getFailingSystem())) continue;
                iterator2.remove();
            }
        }
    }

    protected void noNetProblem() {
        ConsoleAnalysisDomain consoleAnalysisDomain = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        this.workIncident.getProblem().setRefcode("B303000E");
        this.workIncident.getProblem().setServiceableEventText(new BaseMessageText("XPA7688").toString());
        PIFru pIFru = new PIFru();
        if (this.workIncident.getProblem().getParts() != null) {
            this.workIncident.getProblem().getParts().clear();
        }
        this.workIncident.getProblem().addPart((CommonPaFru)pIFru);
        pIFru.setFruClass(12);
        pIFru.setPartNumber("SYSNTWK");
        pIFru.addLocation(consoleAnalysisDomain.getConsoleSystem().getMTMS() + "-SPOT-LAN-CONNECTION");
    }

    protected boolean privateNetFailure(ArrayList arrayList, HashMap hashMap) {
        Object object;
        ArrayList<NetworkInterfaceConfig> arrayList2 = new ArrayList<NetworkInterfaceConfig>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (NetworkInterfaceConfig)iterator.next();
            HashMap hashMap2 = this.getRunningInterfaces(hashMap);
            if (!hashMap2.containsKey(object.getInterfaceID())) continue;
            arrayList2.add((NetworkInterfaceConfig)object);
        }
        Trace.trace((String)TRACE_MASKD, (Object)("activeInterfaces.size()= " + arrayList2.size() + "nonFsPFailures = " + this.nonFspFailures()));
        object = arrayList2.iterator();
        boolean bl = false;
        while (object.hasNext() && !bl) {
            bl = ((NetworkInterfaceConfig)object.next()).isVisible();
            Trace.trace((String)TRACE_MASKD, (Object)("privateNetFailure interface visibility=" + bl));
        }
        return !bl;
    }

    protected boolean nonFspFailures() {
        return this.getRedundantHmcHmcFailures().size() > 0 || this.getHmcPartitionFailures().size() > 0 || this.getRedundantHmcPartitionFailures().size() > 0 || this.getHmcHmcFailures().size() > 0;
    }

    protected boolean isIn(ArrayList arrayList, CommonServiceIncident commonServiceIncident) {
        Iterator iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            CommonServiceIncident commonServiceIncident2 = (CommonServiceIncident)iterator.next();
            if (!commonServiceIncident2.getProblem().getReportingRemoteMachineSystem().equals((Object)commonServiceIncident.getProblem().getReportingRemoteMachineSystem()) || !commonServiceIncident2.getProblem().getFailingSystem().equals((Object)commonServiceIncident.getProblem().getFailingSystem())) continue;
            Trace.trace((String)TRACE_MASKD, (Object)"isIn caught duplicate don't add ");
            return true;
        }
        return bl;
    }

    public HashMap getFailingSystems() {
        return this.failingSystems;
    }

    public void setFailingSystems(HashMap hashMap) {
        this.failingSystems = hashMap;
    }

    protected void addSupportingInfo(Iterator iterator, PIProblem pIProblem) {
        while (iterator.hasNext()) {
            Object object;
            CommonServiceIncident commonServiceIncident = (CommonServiceIncident)iterator.next();
            CommonProblem commonProblem = commonServiceIncident.getProblem();
            Trace.trace((String)TRACE_MASKD, (Object)("addSupportingInfo: refcode = " + commonProblem.getRefcode() + " failingSystem = " + commonProblem.getFailingSystem().getSystemName()));
            if (commonProblem.getPrimaryDataEvent() != null && commonProblem.getPrimaryDataEvent() instanceof SurveillanceNotificationDataEvent && ((SurveillanceNotificationDataEvent)((Object)(object = (SurveillanceNotificationDataEvent)commonProblem.getPrimaryDataEvent()))).getEndPointB() != null) {
                PASystem pASystem = commonProblem.getFailingSystem();
                Trace.trace((String)TRACE_MASKD, (Object)("failingSystem class = " + pASystem.getClass()));
                if (pASystem != null && pASystem instanceof RemotePartitionSystem) {
                    Trace.trace((String)TRACE_MASKD, (Object)"Invoke new attempt to set virtualLED");
                    this.setVirtualLed(pASystem);
                }
            }
            object = new SupportingSurveillanceInfo();
            this.setSupportingInfo((SupportingSurveillanceInfo)object, (PIProblem)commonProblem);
            pIProblem.setSupportingSurvInfo((SupportingSurveillanceInfo)object);
            iterator.remove();
        }
    }

    private void setVirtualLed(PASystem pASystem) {
        Object object;
        Object object2;
        Collection<CIMProperty> collection;
        PICecFsp pICecFsp = null;
        Trace.trace((String)TRACE_MASKD, (Object)("--> setVirtualLed: failingSystem name = " + pASystem.getSystemName()));
        if (this.getLsad() != null) {
            collection = this.getLsad().getMonitoredRemoteMachineSystems();
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (RemoteMachineSystem)object2.next();
                Trace.trace((String)TRACE_MASKD, (Object)("setVitualLed: managedSystem = " + object.getSystemName()));
                if (!object.getMTMS().equals(pASystem.getMTMS()) || !(object instanceof PICecFsp)) continue;
                pICecFsp = (PICecFsp)((Object)object);
            }
        }
        collection = new Vector(2);
        object2 = new Vector(0);
        if (pICecFsp != null) {
            object = new int[]{Integer.parseInt(((RemotePartitionSystem)pASystem).getPartitionSlotId())};
            short[] sArray = new short[]{1};
            UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{new UnsignedInt16(Integer.parseInt(((RemotePartitionSystem)pASystem).getPartitionSlotId()))};
            UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[]{new UnsignedInt8((short)Integer.parseInt("1"))};
            ((Vector)collection).addElement(new CIMProperty("LparIdList", new CIMValue(object, new CIMDataType(23))));
            ((Vector)collection).addElement(new CIMProperty("LedStateList", new CIMValue((Object)sArray, new CIMDataType(21))));
            try {
                PIHscUtil.invokeCIMMethod("localhost", pICecFsp.getCIMObjectPath(), "SetLparSALeds", collection, (Vector)object2);
            }
            catch (CIMException cIMException) {
                Trace.trace((String)TRACE_MASKT, (Object)"Exception during CIM call - results may be truncated");
                Trace.trace((String)TRACE_MASKT, (Object)((Object)cIMException));
                Trace.trace((String)TRACE_MASKD, (Object)"<-- setVirtualLeds failed");
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)("<-- setVirtualLed completed outParams.size =  " + ((Vector)object2).size()));
        if (object2 == null || ((Vector)object2).size() > 0) {
            // empty if block
        }
    }

    public LocalSurveillanceAnalysisDomain getLsad() {
        return this.lsad;
    }

    public void setLsad(LocalSurveillanceAnalysisDomain localSurveillanceAnalysisDomain) {
        this.lsad = localSurveillanceAnalysisDomain;
    }

    public HashMap getRunningInterfaces(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 == null || !string2.equals("R")) continue;
            hashMap2.put(string, string2);
        }
        return hashMap2;
    }
}

